
### Analysis of recall-based sentence production experiment
### Experiment 1 of
### Kentner, Gerrit and Isabelle Franz (2018). 
### No evidence for prosodic effects on the syntactic encoding of complement clauses in German 


## load data frame
dass1All <- read.csv("~/DataCode/DassProd1.txt", sep="\t", header=T)
summary(dass1All)
colnames(dass1All)
#### explanation of the headers 
#SubjectID - participant identifier
#SerialNo - serial number of trial within presentation
#Experiment - name of experiment "dass"
#Item - item identifier
#Verb - embedding verb lemma in stimulus
#Condition - condition 
## a=with "dass", embedded subject iambic,
## b=without "dass", embedded subject iambic;
## c=with "dass", embedded subject trochaic,
## d= without "dass", embedded subject trochaic)
#SentTyp - type of embedded sentence: HS=verb-second main clause syntax, without "dass"; NS=verb-final subordinate clause syntax, with "dass"
#Stimulus - stimulus sentence
#Recall - recall cue
#Block - block number (1,2,3,4)
#DassStimulus - 1 if stimulus contains introduced embedded clause (with "dass"), -1 otherwise
#EmbedSubjStress - 1 if stress of embedded subject on first syllable, 0 otherwise
#EmbedVerbFinStress - 1 if embedding verb ends in a stressed syllable in stimulus sentence, 0 otherwise
#Transcript - transcript of response
#Valid - 1 if response is valid, 0 otherwise
#DassReal - 1 if response includes embedded sentence with "dass", 0 otherwise
#SameVerbForm - 0 if response has embedding verb different from stimulus, otherwise 1
#VerbReal - lemma of actually realised embedding verb
#SameName - 1 if embedded subject in response has same name as embedded subject in stimulus, 0 otherwise
#Name - if SameName == 1, 0, otherwise embedded subject name in response
#Det - 1 if embedded subject contains determiner (as in "der Hans")  
#NameStress - 1 if embedded subject in response starts in a stressed syllable, -1 otherwise
#VerbStress - 1 if embedding verb in response ends in a stressed syllable, -1 otherwise

## Subset valid data points
dass1Valid<-dass1All[dass1All$Valid==1,]

#simple coding of fixed effects with orthogonal sum contrasts (.5 / -.5)
dass1Valid$DassStimulusX <- dass1Valid$DassStimulus/2
dass1Valid$NameStressX <- dass1Valid$NameStress/2
dass1Valid$VerbStressX <- dass1Valid$VerbStress/2
dass1Valid$NameVerbInterX <- (dass1Valid$VerbStressX*dass1Valid$NameStressX)*2 #interaction

library(brms)

## priors for brm models
# weakly informative priors with Normal(0,1) for all fixed effects
priors <- c(set_prior("normal(0, 1)", class = "Intercept"),
            set_prior("normal(0, 1)", class = "b"),
            set_prior("normal(0, 1)", class = "sd"),
            set_prior("lkj(2)", class = "cor"))

#more informative priors for the rhythmic coefficients (sd=.5)
priors2 <- c(set_prior("normal(0, 1)", class = "Intercept"),
             set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
             set_prior("normal(0, .5)", class = "b", coef="NameStressX"),
             set_prior("normal(0, .5)", class = "b", coef="VerbStressX"),
             set_prior("normal(0, .5)", class = "b", coef="NameVerbInterX"),
             set_prior("normal(0, 1)", class = "sd"),
             set_prior("lkj(2)", class = "cor"))

#even more informative priors for the rhythmic coefficients (sd=.2)
priors3 <- c(set_prior("normal(0, 1)", class = "Intercept"),
             set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
             set_prior("normal(0, .2)", class = "b", coef="NameStressX"),
             set_prior("normal(0, .2)", class = "b", coef="VerbStressX"),
             set_prior("normal(0, .2)", class = "b", coef="NameVerbInterX"),
             set_prior("normal(0, 1)", class = "sd"),
             set_prior("lkj(2)", class = "cor"))

## full model for experiment 1 
model1brmFull <- brm(DassReal~DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+
                       (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|SubjectID)+
                       (1+DassStimulusX+NameStressX|Item)+ #VerbStressX is a between item variable
                       (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|VerbReal), 
                     family=bernoulli, 
                     data=dass1Valid, 
                     priors,
                     save_all_pars = TRUE,
                     iter=10000, warmup=2000, chains = 4,
                     control = list(adapt_delta = 0.99))

# get info about posterior distributions
samples_model1 <- as.data.frame(model1brmFull)
posterior_Intercept <- samples_model1$b_Intercept
posterior_DassStimulusX <- samples_model1$b_DassStimulusX
posterior_NameStressX <- samples_model1$b_NameStressX
posterior_VerbStressX <- samples_model1$b_VerbStressX
posterior_NameVerbInterX <- samples_model1$b_NameVerbInterX

mean(posterior_Intercept > 0)
mean(posterior_DassStimulusX > 0)
mean(posterior_NameStressX > 0)
mean(posterior_VerbStressX > 0)
mean(posterior_NameVerbInterX > 0)

# full model with more informative priors (sd=.5)
model1brmFull2 <- brm(DassReal~DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|SubjectID)+
                        (1+DassStimulusX+NameStressX|Item)+ #VerbStressX is between item variable
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|VerbReal), 
                      family=bernoulli, 
                      data=dass1Valid, 
                      priors2, 
                      save_all_pars = TRUE,
                      iter=10000, warmup=2000, chains = 4,
                      control = list(adapt_delta = 0.99))

# full model with more informative priors (sd=.2)
model1brmFull3 <- brm(DassReal~DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|SubjectID)+
                        (1+DassStimulusX+NameStressX|Item)+ #VerbStressX is between item variable
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|VerbReal), 
                      family=bernoulli, 
                      data=dass1Valid, 
                      priors3, 
                      save_all_pars = TRUE,
                      iter=10000, warmup=2000, chains = 4,
                      control = list(adapt_delta = 0.99))

## reduced model for experiment 1 (without coefficient for NameStress and interaction)
model1brmReduced <- brm(DassReal~DassStimulusX+VerbStressX+(1+DassStimulusX+VerbStressX|SubjectID)+
                          (1+DassStimulusX|Item)+ #no random slope for VerbStress (between item factor)
                          (1+DassStimulusX+VerbStressX|VerbReal), 
                        family=bernoulli, 
                        data=dass1Valid, 
                        priors, 
                        save_all_pars = TRUE,
                        iter=10000, warmup=2000, chains = 4,
                        control = list(adapt_delta = 0.99))

# reduced model with more informative priors (sd=.5) (without coefficient for NameStress and interaction)
# priors for reduced model
priors2Red <- c(set_prior("normal(0, 1)", class = "Intercept"),
             set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
             set_prior("normal(0, .5)", class = "b", coef="VerbStressX"),
             set_prior("normal(0, 1)", class = "sd"),
             set_prior("lkj(2)", class = "cor"))

model1brmReduced2 <- brm(DassReal~DassStimulusX+VerbStressX+(1+DassStimulusX+VerbStressX|SubjectID)+
                           (1+DassStimulusX|Item)+ #no random slope for VerbStress (between item factor)
                           (1+DassStimulusX+VerbStressX|VerbReal), 
                         family=bernoulli, 
                         data=dass1Valid, 
                         priors2Red, 
                         save_all_pars = TRUE,
                         iter=10000, warmup=2000, chains = 4,
                         control = list(adapt_delta = 0.99))

# reduced model with more informative priors (sd=.2) (without coefficient for NameStress and interaction)
# priors for reduced model
priors3Red <- c(set_prior("normal(0, 1)", class = "Intercept"),
                set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
                set_prior("normal(0, .2)", class = "b", coef="VerbStressX"),
                set_prior("normal(0, 1)", class = "sd"),
                set_prior("lkj(2)", class = "cor"))

model1brmReduced3 <- brm(DassReal~DassStimulusX+VerbStressX+(1+DassStimulusX+VerbStressX|SubjectID)+
                           (1+DassStimulusX|Item)+ #no random slope for VerbStress (between item factor)
                           (1+DassStimulusX+VerbStressX|VerbReal), 
                         family=bernoulli, 
                         data=dass1Valid, 
                         priors3Red, 
                         save_all_pars = TRUE,
                         iter=10000, warmup=2000, chains = 4,
                         control = list(adapt_delta = 0.99))

## null model for experiment 1 (without any rhythmic coefficients)
model1brmNull <- brm(DassReal~DassStimulusX+(1+DassStimulusX|SubjectID)+(1+DassStimulusX|Item)+(1+DassStimulusX|VerbReal), 
                     family=bernoulli, 
                     data=dass1Valid, 
                     priors, 
                     save_all_pars = TRUE,
                     iter=10000, warmup=2000, chains = 4,
                     control = list(adapt_delta = 0.99))

## Model comparison via Bayes factor
# Bayes factor comparing the reduced model to the full model (weakly informative priors with sd=1)
BF_RedFull1 <-bayes_factor(model1brmReduced, model1brmFull) 
BF_RedFull1

# Bayes factor comparing the reduced model to the full model (priors for parameters of interest with sd=.5)
BF2_RedFull1 <-bayes_factor(model1brmReduced2, model1brmFull2) 
BF2_RedFull1

# Bayes factor comparing the reduced model to the full model (priors for parameters of interest with sd=.2)
BF3_RedFull1 <-bayes_factor(model1brmReduced3, model1brmFull3) 
BF3_RedFull1

# Bayes factor comparing the null model to the full model (weakly informative priors with sd=1)
BF_NullFull1 <-bayes_factor(model1brmNull, model1brmFull) 
BF_NullFull1

# Bayes factor comparing the null model to the full model (priors for parameters of interest with sd=.5)
BF2_NullFull1 <-bayes_factor(model1brmNull, model1brmFull2) # Bayes factor comparing the null model to the full model
BF2_NullFull1

# Bayes factor comparing the null model to the full model (priors for parameters of interest with sd=.5)
BF3_NullFull1 <-bayes_factor(model1brmNull, model1brmFull3) # Bayes factor comparing the null model to the full model
BF3_NullFull1
BF_RedFull1


# Leave one out cross-validation
Loo1NullFull2 <- loo(model1brmNull, model1brmFull2)
Loo1NullFull2
#LOOIC    SE
#model1brmNull                  357.33 25.17
#model1brmFull2                 366.95 25.60
#model1brmNull - model1brmFull2  -9.62  3.97

Loo1NullFull3 <- loo(model1brmNull, model1brmFull3)
Loo1NullFull3
#LOOIC    SE
#model1brmNull                  357.33 25.17
#model1brmFull3                 365.82 25.52
#model1brmNull - model1brmFull3  -8.49  3.37


