### Analysis of recall-based sentence production experiments
### Experiments 1 and 2 of
### Kentner, Gerrit and Isabelle Franz (2018). 
### No evidence for prosodic effects on the syntactic encoding of complement clauses in German 

### Load datasets of both production experiments
dass1All <- read.csv("~/DataCode/DassProd1.txt", sep="\t", header=T)
dass2All <- read.csv("~/DataCode/DassProd2.txt", sep="\t", header=T)

# subset valid data points
dass1Valid<-dass1All[dass1All$Valid==1,]
dass2Valid<-dass2All[dass2All$Valid==1,]

#different subjects nested in different experiments
#--> unique names for subjects
dass1Valid$ExpRun <- "1"
dass2Valid$ExpRun <- "2"
dass1Valid$SubjectIDx <- with(dass1Valid, paste(ExpRun,SubjectID))
dass2Valid$SubjectIDx <- with(dass2Valid, paste(ExpRun,SubjectID))

# use the same colnames for both data sets
colnames(dass1Valid)<-colnames(dass2Valid)    

# combine data sets
dass12Valid <- rbind(dass1Valid, dass2Valid)
dim(dass12Valid)
head(dass12Valid)
levels(factor(dass12Valid$SubjectIDx))

# orthogonal sum contrasts
dass12Valid$DassStimulusX <- dass12Valid$DassStimulus/2
dass12Valid$NameStressX <- dass12Valid$NameStress/2
dass12Valid$VerbStressX <- dass12Valid$VerbStress/2
dass12Valid$NameVerbInterX <- (dass12Valid$VerbStressX*dass12Valid$NameStressX)*2

library(brms)

## priors for brm models
# weakly informative priors with Normal(0,1) for all fixed effects
priors <- c(set_prior("normal(0, 1)", class = "Intercept"),
            set_prior("normal(0, 1)", class = "b"),
            set_prior("normal(0, 1)", class = "sd"),
            set_prior("lkj(2)", class = "cor"))

#more informative priors for the rhythmic coefficients (sd=.5)
priors2 <- c(set_prior("normal(0, 1)", class = "Intercept"),
             set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
             set_prior("normal(0, .5)", class = "b", coef="NameStressX"),
             set_prior("normal(0, .5)", class = "b", coef="VerbStressX"),
             set_prior("normal(0, .5)", class = "b", coef="NameVerbInterX"),
             set_prior("normal(0, 1)", class = "sd"),
             set_prior("lkj(2)", class = "cor"))

#even more informative priors for the rhythmic coefficients (sd=.2)
priors3 <- c(set_prior("normal(0, 1)", class = "Intercept"),
             set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
             set_prior("normal(0, .2)", class = "b", coef="NameStressX"),
             set_prior("normal(0, .2)", class = "b", coef="VerbStressX"),
             set_prior("normal(0, .2)", class = "b", coef="NameVerbInterX"),
             set_prior("normal(0, 1)", class = "sd"),
             set_prior("lkj(2)", class = "cor"))

# full model
model12brmFull <- brm(DassReal~DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+ExpRun+
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|ExpRun/SubjectID)+
                        (1+DassStimulusX+NameStressX|Item)+
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+ExpRun|VerbReal), 
                      priors,
                      family=bernoulli, 
                      data=dass12Valid, 
                      save_all_pars = TRUE,
                      iter=10000, warmup = 2000, chains = 4,
                      control = list(adapt_delta = 0.99))

# full model with more informative priors (sd=.5)
model12brmFull2 <- brm(DassReal~DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+ExpRun+
                         (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|ExpRun/SubjectID)+
                         (1+DassStimulusX+NameStressX|Item)+
                         (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+ExpRun|VerbReal), 
                       priors2,
                       family=bernoulli, 
                       data=dass12Valid, 
                       save_all_pars = TRUE,
                       iter=10000, warmup = 2000, chains = 4,
                       control = list(adapt_delta = 0.99))

# full model with more informative priors (sd=.2)
model12brmFull3 <- brm(DassReal~DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+ExpRun+
                         (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|ExpRun/SubjectID)+
                         (1+DassStimulusX+NameStressX|Item)+
                         (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+ExpRun|VerbReal), 
                       priors3,
                       family=bernoulli, 
                       data=dass12Valid, 
                       save_all_pars = TRUE,
                       iter=10000, warmup = 2000, chains = 4,
                       control = list(adapt_delta = 0.99))


#more informative priors (sd=.5) for reduced model
priors2Red <- c(set_prior("normal(0, 1)", class = "Intercept"),
                set_prior("normal(0, 1)", class = "b"),
                set_prior("normal(0, .5)", class = "b", coef="VerbStressX"),
                set_prior("normal(0, 1)", class = "sd"),
                set_prior("lkj(2)", class = "cor"))

#even more informative priors (sd=.2) for reduced model
priors3Red <- c(set_prior("normal(0, 1)", class = "Intercept"),
                set_prior("normal(0, 1)", class = "b"),
                set_prior("normal(0, .2)", class = "b", coef="VerbStressX"),
                set_prior("normal(0, 1)", class = "sd"),
                set_prior("lkj(2)", class = "cor"))

# reduced model with weakly informative priors (sd=1)
model12brmRed <- brm(DassReal~DassStimulusX+VerbStressX+ExpRun+
                       (1+DassStimulusX+VerbStressX|ExpRun/SubjectID)+
                       (1+DassStimulusX|Item)+
                       (1+DassStimulusX+VerbStressX+ExpRun|VerbReal), 
                     priors,
                     family=bernoulli, 
                     data=dass12Valid, 
                     save_all_pars = TRUE,
                     iter=10000, warmup = 2000, chains = 4,
                     control = list(adapt_delta = 0.99))

# reduced model with more informative priors (sd=.5)
model12brmRed2 <- brm(DassReal~DassStimulusX+VerbStressX+ExpRun+
                        (1+DassStimulusX+VerbStressX|ExpRun/SubjectID)+
                        (1+DassStimulusX|Item)+
                        (1+DassStimulusX+VerbStressX+ExpRun|VerbReal), 
                      priors2Red,
                      family=bernoulli, 
                      data=dass12Valid, 
                      save_all_pars = TRUE,
                      iter=10000, warmup = 2000, chains = 4,
                      control = list(adapt_delta = 0.99))

# reduced model with more informative priors (sd=.2)
model12brmRed3 <- brm(DassReal~DassStimulusX+VerbStressX+ExpRun+
                        (1+DassStimulusX+VerbStressX|ExpRun/SubjectID)+
                        (1+DassStimulusX|Item)+
                        (1+DassStimulusX+VerbStressX+ExpRun|VerbReal), 
                      priors3Red,
                      family=bernoulli, 
                      data=dass12Valid, 
                      save_all_pars = TRUE,
                      iter=10000, warmup = 2000, chains = 4,
                      control = list(adapt_delta = 0.99))

# null model (without rhythmic coefficients)
model12brmNull <- brm(DassReal~DassStimulusX+ExpRun+
                        (1+DassStimulusX|ExpRun/SubjectID)+
                        (1+DassStimulusX|Item)+
                        (1+DassStimulusX+ExpRun|VerbReal), 
                      priors,
                      family=bernoulli, 
                      data=dass12Valid, 
                      save_all_pars = TRUE,
                      iter=10000, warmup = 2000, chains = 4,
                      control = list(adapt_delta = 0.99))



## Model comparison via Bayes factor

# Bayes factor comparing the reduced model to the full model (weakly informative priors on all fixed effects with sd=1)
BF_RedFull12 <-bayes_factor(model12brmRed, model12brmFull) 
BF_RedFull12

# Bayes factor comparing the reduced model to the full model (with more informative priors, sd=.5)
BF2_RedFull12 <-bayes_factor(model12brmRed2, model12brmFull2) 
BF2_RedFull12

# Bayes factor comparing the reduced model to the full model (with more informative priors, sd=.2)
BF3_RedFull12 <-bayes_factor(model12brmRed3, model12brmFull3)
BF3_RedFull12

# Bayes factor comparing the null model to the full model (weakly informative priors on all fixed effects with sd=1)
BF_NullFull12 <-bayes_factor(model12brmNull, model12brmFull) 
BF_NullFull12

# Bayes factor comparing the null model to the full model (more informative priors with sd=.5)
BF2_NullFull12 <-bayes_factor(model12brmNull, model12brmFull2) 
BF2_NullFull12

# Bayes factor comparing the null model to the full model (more informative priors with sd=.2)
BF3_NullFull12 <- bayes_factor(model12brmNull, model12brmFull3)
BF3_NullFull12


# Leave-one-out cross-validation
Loo12NullFull3 <- loo(model12brmNull, model12brmFull3)
Loo12NullFull3
#model12brmNull                   952.68 43.81
#model12brmFull3                  964.46 44.68
#model12brmNull - model12brmFull3 -11.78  5.43