### Analysis of recall-based sentence production experiment
### Experiment 2 of
### Kentner, Gerrit and Isabelle Franz (2018). 
### No evidence for prosodic effects on the syntactic encoding of complement clauses in German 
### Experiment 2

#load data frame
dass2All <- read.csv("~/DataCode/DassProd2.txt", sep="\t", header=T)
summary(dass2All)

#### explanation of the headers 
#SubjectID - participant identifier
#SerialNo - serial number of trial within presentation
#Experiment - name of experiment "dass"
#Item - item identifier
#Verb - embedding verb lemma in stimulus
#Condition - condition 
##a=with "dass", embedded subject iambic,
##b=without "dass", embedded subject iambic;
##c=with "dass", embedded subject trochaic,
##d= without "dass", embedded subject trochaic)
#SentTyp - type of embedded sentence: HS=verb-second main clause syntax, without "dass"; NS=verb-final subordinate clause syntax, with "dass"
#Stimulus - stimulus sentence
#Recall - recall cue
#Block - block number (1,2,3,4)
#DassStimulus - 1 if stimulus contains introduced embedded clause (with "dass"), -1 otherwise
#EmbedSubjStress - 1 if stress of embedded subject in stimulus sentence is on first syllable, -1 otherwise
#EmbeddingVerbStress - 1 if embedding verb in stimulus sentence ends in a stressed syllable in stimulus sentence, -1 otherwise
#Transcript - transcript of response
#Valid - 1 if response is valid, 0 otherwise
#DassReal - 1 if response includes embedded sentence with "dass", 0 otherwise
#SameVerbForm - 0 if response has embedding verb different from stimulus, otherwise 1
#VerbReal - lemma of actually realised embedding verb
#SameName - 1 if embedded subject in response has same name as embedded subject in stimulus, 0 otherwise
#Name - if SameName == 1, 0, otherwise embedded subject name in response
#Det - 1 if embedded subject contains determiner (as in "der Hans")  
#NameStress - 1 if embedded subject in response starts in a stressed syllable, -1 otherwise
#VerbStress - 1 if embedding verb in response ends in a stressed syllable, -1 otherwise


## Subset valid data points
dass2Valid<-dass2All[dass2All$Valid==1,]

# orthogonal sum contrasts
dass2Valid$DassStimulusX <- dass2Valid$DassStimulus/2
dass2Valid$NameStressX <- dass2Valid$NameStress/2
dass2Valid$VerbStressX <- dass2Valid$VerbStress/2
dass2Valid$NameVerbInterX <- (dass2Valid$VerbStressX*dass2Valid$NameStressX)*2

## brms models for experiment 2 
library(brms)

## priors for brm models
# weakly informative priors with Normal(0,1) for all fixed effects
priors <- c(set_prior("normal(0, 1)", class = "Intercept"),
            set_prior("normal(0, 1)", class = "b"),
            set_prior("normal(0, 1)", class = "sd"),
            set_prior("lkj(2)", class = "cor"))

#more informative priors for the rhythmic coefficients (sd=.5)
priors2 <- c(set_prior("normal(0, 1)", class = "Intercept"),
             set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
             set_prior("normal(0, .5)", class = "b", coef="NameStressX"),
             set_prior("normal(0, .5)", class = "b", coef="VerbStressX"),
             set_prior("normal(0, .5)", class = "b", coef="NameVerbInterX"),
             set_prior("normal(0, 1)", class = "sd"),
             set_prior("lkj(2)", class = "cor"))

#even more informative priors for the rhythmic coefficients (sd=.2)
priors3 <- c(set_prior("normal(0, 1)", class = "Intercept"),
             set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
             set_prior("normal(0, .2)", class = "b", coef="NameStressX"),
             set_prior("normal(0, .2)", class = "b", coef="VerbStressX"),
             set_prior("normal(0, .2)", class = "b", coef="NameVerbInterX"),
             set_prior("normal(0, 1)", class = "sd"),
             set_prior("lkj(2)", class = "cor"))


model2brmFull <- brm(DassReal~DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+
                       (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|SubjectID)+
                       (1+DassStimulusX+NameStressX|Item)+ #no random slopes for VerbStressX (between item factor)
                       (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|VerbReal), 
                     priors,
                     family=bernoulli, 
                     data=dass2Valid, 
                     save_all_pars = TRUE,
                     iter=10000, warmup = 2000, chains = 4,
                     control = list(adapt_delta = 0.99))

# get info about posterior distribution
samples_model2 <- as.data.frame(model2brmFull)
posterior_Intercept2 <- samples_model2$b_Intercept
posterior_DassStimulusX2 <- samples_model2$b_DassStimulusX
posterior_NameStressX2 <- samples_model2$b_NameStressX
posterior_VerbStressX2 <- samples_model2$b_VerbStressX
posterior_NameVerbInterX2 <- samples_model2$b_NameVerbInterX
mean(posterior_Intercept2 > 0)
mean(posterior_DassStimulusX2 > 0)
mean(posterior_NameStressX2 > .55)
mean(posterior_VerbStressX2 > .55)
mean(posterior_NameVerbInterX2 > 0)

# full model with more informative priors (sd=.5)
model2brmFull2 <- brm(DassReal~DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|SubjectID)+
                        (1+DassStimulusX+NameStressX|Item)+ #no random slopes for VerbStressX (between item factor)
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|VerbReal), 
                      priors2,
                      family=bernoulli, 
                      data=dass2Valid, 
                      save_all_pars = TRUE,
                      iter=10000, warmup = 2000, chains = 4,
                      control = list(adapt_delta = 0.99))

# full model with more informative priors (sd=.2)
model2brmFull3 <- brm(DassReal~DassStimulusX+NameStressX+VerbStressX+NameVerbInterX+
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|SubjectID)+
                        (1+DassStimulusX+NameStressX|Item)+ #no random slopes for VerbStressX (between item factor)
                        (1+DassStimulusX+NameStressX+VerbStressX+NameVerbInterX|VerbReal), 
                      priors3,
                      family=bernoulli, 
                      data=dass2Valid, 
                      save_all_pars = TRUE,
                      iter=10000, warmup = 2000, chains = 4,
                      control = list(adapt_delta = 0.99))

## reduced model for experiment 2 (without coefficient for NameStress and Interaction)
model2brmReduced <- brm(DassReal~DassStimulusX+VerbStressX+(1+DassStimulusX+VerbStressX|SubjectID)+
                          (1+DassStimulusX|Item)+ #no random slopes for VerbStressX (between item factor)
                          (1+DassStimulusX+VerbStressX|VerbReal), 
                        family=bernoulli, 
                        data=dass2Valid, 
                        priors, 
                        save_all_pars = TRUE,
                        iter=10000, warmup = 2000, chains = 4,
                        control = list(adapt_delta = 0.99))

# reduced model with more informative priors (sd=.5) (without coefficient for NameStress and interaction)
# priors for reduced model 
priors2Red <- c(set_prior("normal(0, 1)", class = "Intercept"),
                set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
                set_prior("normal(0, .5)", class = "b", coef="VerbStressX"),
                set_prior("normal(0, 1)", class = "sd"),
                set_prior("lkj(2)", class = "cor"))

model2brmReduced2 <- brm(DassReal~DassStimulusX+VerbStressX+(1+DassStimulusX+VerbStressX|SubjectID)+
                           (1+DassStimulusX|Item)+ #no random slopes for VerbStressX (between item factor)
                           (1+DassStimulusX+VerbStressX|VerbReal), 
                         family=bernoulli, 
                         data=dass2Valid, 
                         priors2Red, 
                         save_all_pars = TRUE,
                         iter=10000, warmup = 2000, chains = 4,
                         control = list(adapt_delta = 0.99))

# reduced model with more informative priors (sd=.2) (without coefficient for NameStress and interaction)
# priors for reduced model (sd=.2)
priors3Red <- c(set_prior("normal(0, 1)", class = "Intercept"),
                set_prior("normal(0, 1)", class = "b", coef="DassStimulusX"),
                set_prior("normal(0, .2)", class = "b", coef="VerbStressX"),
                set_prior("normal(0, 1)", class = "sd"),
                set_prior("lkj(2)", class = "cor"))

model2brmReduced3 <- brm(DassReal~DassStimulusX+VerbStressX+(1+DassStimulusX+VerbStressX|SubjectID)+
                           (1+DassStimulusX|Item)+ #no random slopes for VerbStressX (between item factor)
                           (1+DassStimulusX+VerbStressX|VerbReal), 
                         family=bernoulli, 
                         data=dass2Valid, 
                         priors3Red, 
                         save_all_pars = TRUE,
                         iter=10000, warmup = 2000, chains = 4,
                         control = list(adapt_delta = 0.99))

# null model for experiment 2 (without any rhythmic coefficients)
model2brmNull <- brm(DassReal~DassStimulusX+(1+DassStimulusX|SubjectID)+(1+DassStimulusX|Item)+(1+DassStimulusX|VerbReal), 
                     family=bernoulli, 
                     data=dass2Valid, 
                     priors, 
                     save_all_pars = TRUE,
                     iter=10000, warmup = 2000, chains = 4,
                     control = list(adapt_delta = 0.99))

## model comparison via Bayes factors
# Bayes factor comparing the reduced model to the full model (weakly informative priors on all fixed effects with sd=1)
BF_RedFull2 <-bayes_factor(model2brmReduced, model2brmFull) 
BF_RedFull2

# Bayes factor comparing the reduced model to the full model (with more informative priors, sd=.5)
BF2_RedFull2 <-bayes_factor(model2brmReduced2, model2brmFull2) 
BF2_RedFull2

# Bayes factor comparing the reduced model to the full model (with more informative priors, sd=.2)
BF3_RedFull2 <-bayes_factor(model2brmReduced3, model2brmFull3)
BF3_RedFull2

# Bayes factor comparing the null model to the full model (weakly informative priors on all fixed effects with sd=1)
BF_NullFull2 <-bayes_factor(model2brmNull, model2brmFull) 
BF_NullFull2

# Bayes factor comparing the null model to the full model (more informative priors with sd=.5)
BF2_NullFull2 <-bayes_factor(model2brmNull, model2brmFull2) 
BF2_NullFull2

# Bayes factor comparing the null model to the full model (more informative priors with sd=.2)
BF2_NullFull3 <-bayes_factor(model2brmNull, model2brmFull3)
BF2_NullFull3

