########################################################
### Reanalysis of Lee & Gibbons
########################################################
## Lee & Gibbon's data based on information in Table 2 of 
# Lee, M. W., & Gibbons, J. (2007). 
# Rhythmic alternation and the optional complementiser in English: 
# New evidence of phonological influence on grammatical encoding. 
# Cognition, 105(2), 446-456.

#load Lee & Gibbon's data
LGthat <- read.csv("~/DataCode/LeeGibbonsSimData.csv", sep=";", header=T)

summary(LGthat)

# recode to orthogonal sum contrasts (.5 / -.5)
LGthat$StressOC <- LGthat$Stress-0.5 #stress embedded subject: .5 if initial syllable stressed, -.5 otherwise
LGthat$dassStimulusOC <- LGthat$dassStimulus-0.5 #.5 if optional "that" in stimulus sentence, -.5 otherwise
LGthat$RecallCueOC <- ifelse(LGthat$RecallCue=="Main",-0.5,.05) #.5 if source of recall cue in embedded clause, otherwise -.5

# model coefficients of Stress of embedded subject, source of recall cue and complementiser in stimulus sentence (for details see Lee & Gibbons 2007)
library(brms)
#weakly informative priors
priors <- c(set_prior("normal(0, 1)", class = "Intercept"),
            set_prior("normal(0, 1)", class = "b"))


ModelLGbrm <- brm(dassReal~StressOC+RecallCueOC+dassStimulusOC, priors, family="bernoulli", data=LGthat)

summary(ModelLGbrm)

# get info about posterior distributions
samples_modelLG <- as.data.frame(ModelLGbrm)
posterior_InterceptOC <- samples_modelLG$b_Intercept
posterior_DassStimulusOC <- samples_modelLG$b_dassStimulusOC
posterior_NameStressOC <- samples_modelLG$b_StressOC
posterior_RecallCueOC <- samples_modelLG$b_RecallCueOC

mean(posterior_InterceptOC > 0)
mean(posterior_DassStimulusOC > 0)
mean(posterior_NameStressOC > 0)
mean(posterior_RecallCueOC > 0)

